<?php
namespace PhpUnitsOfMeasure\PhysicalQuantity;

use PhpUnitsOfMeasure\AbstractPhysicalQuantity;
use PhpUnitsOfMeasure\UnitOfMeasure;
use PhpUnitsOfMeasure\HasSIUnitsTrait;

class Pressure extends AbstractPhysicalQuantity
{
    use HasSIUnitsTrait;

    protected static $unitDefinitions;

    protected static function initialize()
    {
        // Pascal
        $pascal = UnitOfMeasure::nativeUnitFactory('Pa');
        $pascal->addAlias('pascal');
        static::addUnit($pascal);

	/*
        static::addMissingSIPrefixedUnits(
            $pascal,
            1,
            '%pPa',
            [
                '%Ppascal',
            ]
        );
	 */
	
        // Megapascal
        $newUnit= UnitOfMeasure::linearUnitFactory('MPa', 1e6);
        $newUnit->addAlias('megapascal');
        static::addUnit($newUnit);
	
        // kilopascal
        $newUnit= UnitOfMeasure::linearUnitFactory('kPa', 1e3);
        $newUnit->addAlias('kilopascal');
        static::addUnit($newUnit);
	
        // hectopascal
        $newUnit= UnitOfMeasure::linearUnitFactory('hPa', 1e2);
        $newUnit->addAlias('hectopascal');
        static::addUnit($newUnit);

        // Atmosphere
        $newUnit = UnitOfMeasure::linearUnitFactory('atm', 101325);
        $newUnit->addAlias('atmosphere');
        $newUnit->addAlias('atmospheres');
        static::addUnit($newUnit);

        // Bar
        $newUnit= UnitOfMeasure::linearUnitFactory('bar', 1e5);
        $newUnit->addAlias('bar');
        static::addUnit($newUnit);
	
        // millibar
        $newUnit= UnitOfMeasure::linearUnitFactory('mbar', 1e2);
        $newUnit->addAlias('millibar');
        static::addUnit($newUnit);

	/*
        // Bar
        $bar = UnitOfMeasure::linearUnitFactory('bar', 1e5);
        static::addUnit($bar);

        static::addMissingSIPrefixedUnits(
            $bar,
            1,
            '%pbar'
        );
	 */

        // Inch of Mercury
        $newUnit = UnitOfMeasure::linearUnitFactory('inHg', 3.386389e3);
        $newUnit->addAlias('inches of mercury');
        static::addUnit($newUnit);

        // Millimeter of Mercury
        $newUnit = UnitOfMeasure::linearUnitFactory('mmHg', 133.3224);
        $newUnit->addAlias('millimeters of mercury');
        $newUnit->addAlias('millimetres of mercury');
        $newUnit->addAlias('torr');
        static::addUnit($newUnit);

        // Pound per Square Inch
        $newUnit = UnitOfMeasure::linearUnitFactory('psi', 6.894757e3);
        $newUnit->addAlias('pounds per square inch');
	static::addUnit($newUnit);
	
	// Pound per Square Inch
	$newUnit = UnitOfMeasure::linearUnitFactory('inH2O', 248.84);
	$newUnit->addAlias('inches of water');
        static::addUnit($newUnit);
    }
}
